import { StarXpandCommand } from "star-io10-web";

export class ReceiptSample10_Order2_Template {
  static async createTemplate(): Promise<string> {
    let builder = new StarXpandCommand.StarXpandCommandBuilder();

    builder.addDocument(
      new StarXpandCommand.DocumentBuilder()
        .settingPrintableArea(72.0)
        .addPrinter(
          new StarXpandCommand.PrinterBuilder()
            .styleCjkCharacterPriority([
              StarXpandCommand.Printer.CjkCharacterType.Japanese,
            ])
            .actionPrintText(
              "${time}",
              new StarXpandCommand.Printer.TextParameter().setWidth(8),
            )
            .actionPrintText(
              "${staff_name}",
              new StarXpandCommand.Printer.TextParameter().setWidth(
                20,
                new StarXpandCommand.Printer.TextWidthParameter()
                  .setAlignment(StarXpandCommand.Printer.TextAlignment.Right)
                  .setWidthType(StarXpandCommand.Printer.TextWidthType.Full),
              ),
            )
            .styleMagnification(
              new StarXpandCommand.MagnificationParameter(2, 2),
            )
            .styleInvert(true)
            .actionPrintText(" ${classification} ")
            .styleInvert(false)
            .actionPrintText(
              " ${table_number}",
              new StarXpandCommand.Printer.TextParameter().setWidth(10),
            )
            .add(
              new StarXpandCommand.PrinterBuilder()
                .styleLineSpace(0.0)
                .styleMagnification(
                  new StarXpandCommand.MagnificationParameter(1, 1),
                )
                .actionPrintText(
                  "${visitors}名\n",
                  new StarXpandCommand.Printer.TextParameter().setWidth(
                    20,
                    new StarXpandCommand.Printer.TextWidthParameter().setAlignment(
                      StarXpandCommand.Printer.TextAlignment.Right,
                    ),
                  ),
                ),
            )
            .actionFeed(0.5)
            .actionPrintRuledLine(
              new StarXpandCommand.Printer.RuledLineParameter(72.0),
            )
            .add(
              new StarXpandCommand.PrinterBuilder(
                new StarXpandCommand.Printer.PrinterParameter().setTemplateExtension(
                  new StarXpandCommand.TemplateExtensionParameter().setEnableArrayFieldData(
                    true,
                  ),
                ),
              )
                .actionPrintText(
                  "${item_list.name}",
                  new StarXpandCommand.Printer.TextParameter().setWidth(22),
                )
                .actionPrintText(
                  "${item_list.quantity}\n",
                  new StarXpandCommand.Printer.TextParameter().setWidth(
                    2,
                    new StarXpandCommand.Printer.TextWidthParameter().setAlignment(
                      StarXpandCommand.Printer.TextAlignment.Right,
                    ),
                  ),
                ),
            )
            .actionCut(StarXpandCommand.Printer.CutType.Partial),
        ),
    );
    return await builder.getCommands();
  }

  static async getFieldData(): Promise<string> {
    return Promise.resolve(
      `{
    "time" : "19:30",
    "staff_name" : "静岡太郎",
    "classification" : "新",
    "table_number" : "A-2",
    "visitors" : 4,
    "item_list" : [
        {
            "name" : "生ビール",
            "quantity" : "4"
        },
        {
            "name" : "(中ジョッキ)"
        },
        {
            "name" : "お急ぎ"
        }
    ]
}`,
    );
  }
}
